/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.script.scriptrun;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.zencode.scriptrun.ScriptRunConfiguration;
import com.blamejared.crafttweaker.impl.script.scriptrun.RunInfo;
import com.blamejared.crafttweaker.impl.script.scriptrun.runner.IScriptRunner;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openzen.zencode.java.logger.ScriptingEngineLogger;
import org.openzen.zencode.shared.SourceFile;

enum DecoratedRunKind {
    SYNTAX(ScriptRunConfiguration.RunKind.SYNTAX_CHECK, "Compiling scripts: this is only a syntax check, no actions will be applied"),
    FORMAT(ScriptRunConfiguration.RunKind.FORMAT, "Formatting scripts"),
    EXECUTE(ScriptRunConfiguration.RunKind.EXECUTE, "Compiling and executing scripts");

    private static final Map<ScriptRunConfiguration.RunKind, DecoratedRunKind> VALUES;
    private final ScriptRunConfiguration.RunKind kind;
    private final String logMessage;

    private DecoratedRunKind(ScriptRunConfiguration.RunKind kind, String logMessage) {
        this.kind = kind;
        this.logMessage = logMessage;
    }

    static DecoratedRunKind decorate(ScriptRunConfiguration.RunKind kind) {
        return VALUES.get((Object)kind);
    }

    ScriptRunConfiguration.RunKind kind() {
        return this.kind;
    }

    IScriptRunner runner(RunInfo info, List<SourceFile> sources, ScriptingEngineLogger logger) {
        return new DecoratedScriptRunner(IScriptRunner.of(info, sources, logger), this.logMessage);
    }

    static {
        VALUES = Arrays.stream(DecoratedRunKind.values()).collect(Collectors.toMap(DecoratedRunKind::kind, Function.identity()));
    }

    private record DecoratedScriptRunner(IScriptRunner runner, String message) implements IScriptRunner
    {
        @Override
        public void run() throws Exception {
            CraftTweakerAPI.LOGGER.info(this.message());
            this.runner().run();
        }
    }
}

